<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<br/>
<div class="row">
<div class="col-md-6">
    <div class="panel panel-default">
        <div class="panel-body">
        <?php echo form_open('exam_configuration/create'); ?>        
        <?php        
        $options;        
        foreach($exam_standards as $exam_standard) :
            $options[$exam_standard->exam_standard_ID] = $exam_standard->standard_name;
        endforeach;        
        echo form_dropdown(array(
                            'name'=>'exam_standard_ID',
                            'label'=>'Exam Standard :',
                            'options'=> $options,
                            'placeholder'=> 'Select a Exam Standard'
                          ));
        ?>
        <?php           
        echo form_dropdown(array(
                            'name'=>'exam_org_ID',
                            'label'=>'Exam Organisation :',
                            'options'=> array(),
                            'placeholder'=> 'Select a Exam Organisation',                          
                          ));
        
        ?>
        <?php            
        echo form_dropdown(array(
                            'name'=>'post_level_ID',
                            'label'=>'Post Level :',
                            'options'=> array(),
                            'placeholder'=> 'Select a Post Level'
                          ));
        ?>
        <?php echo form_input(array('name'=>'exam_duration','label'=>'Exam Duration (in Mins.):')); ?>
        <?php echo form_input(array('name'=>'nos_ques','label'=>'Total No. of Questions per Exam :')); ?>
        <fieldset>
          <legend>Subjects :</legend>
          <a href="<?= base_url('exam_configuration/') ?>add_subject" data-toggle="modal" data-target="#ajax-modal" class="btn btn-success btn-sm pull-right ajax" data-replace="#ajax-form-container">
            <span class="fa fa-plus"></span> Add New Subject
          </a>
          <table class="table table-striped">
            <thead>
              <tr>
                <th>Subject</th>
                <th><div data-toggle="tooltip" data-placement="top" data-original-title="No. of Questions to include from this Subject" >
                  No. of Questions
                  </div>
                </th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody id="subject-list">
            </tbody>
          </table>
        </fieldset>
        <br>
        <?php echo form_submit(array('value' => 'Create')); ?>
        <?php echo form_close(); ?>
    </div>
    </div>
</div>
</div>

<!-- Modal -->
<div id="ajax-modal" class="modal fade" role="dialog">
  <div class="modal-dialog" >
    <div class="modal-content">
    <div id="ajax-form-container">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title"></h4>
      </div>
      <div class="modal-body">
        <p>Loading...</p>
      </div>
      <div class="modal-footer">
      </div>
    </div>
    </div>
  </div>
</div>

<script>
    $(document).ready(function(){ 
        
     $('#exam_org_ID').prop('disabled','disabled');
     $('#post_level_ID').prop('disabled','disabled');
     
    // Selected exam organization list    
    $('#exam_standard_ID').on('change',function(){
      var examStandardID = $(this).find('option:selected').val();  
      var url = '<?php echo base_url('exam_configuration/selectExamOrg/'); ?>'+ examStandardID;
        $.getJSON(url,function(data){
           if(data){
              var options ="<option value=''>Select a Exam Organisation</option>\n";
              $.each(data,function(i,val){
                   
                   options += "<option value='"+val.exam_org_ID +"'>"+val.exam_org_name+"</option>\n";
                   
               });
               
              $('#exam_org_ID').removeProp('disabled').html(options);
           }
        });
    });    
    
     // Selected post level list    
    $('#exam_org_ID').on('change',function(){
      var examOrgID = $(this).find('option:selected').val();  
      var url = '<?php echo base_url('exam_configuration/selectPostLevel/'); ?>'+ examOrgID;
        $.getJSON(url,function(data){
           if(data){
              var options ="<option value=''>Select a Post Level</option>\n";
              $.each(data,function(i,val){
                   
                   options += "<option value='"+val.post_level_ID +"'>"+val.post_level_name+"</option>\n";
                   
               });
               
              $('#post_level_ID').removeProp('disabled').html(options);
           }
        });
    });
});
</script>
    

